% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotGene-methods.R
\name{plotGene}
\alias{plotGene}
\alias{plotGene,INSPEcT-method}
\title{Plot the pre-modeled and modeled profiles for one gene}
\usage{
plotGene(
  object,
  ix,
  relative_expression = FALSE,
  fix.yaxis = FALSE,
  priors = TRUE,
  constantModel = FALSE
)

\S4method{plotGene}{INSPEcT}(
  object,
  ix,
  relative_expression = FALSE,
  fix.yaxis = FALSE,
  priors = TRUE,
  constantModel = FALSE
)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{ix}{Eiher a rowname or a row number to select one single gene}

\item{relative_expression}{A logical, indicating whether expressions are rates 
should be plotted relative to their initial value (Default=FALSE).}

\item{fix.yaxis}{A logical, indicating whether the limits for y-axis of 
degradation and processing rates should be fixed
relative to their distributions}

\item{priors}{A logical, if true the priors of the rates are plotted}

\item{constantModel}{A logical, if true the constant model for the + nascent modeling are shown}
}
\value{
A list containing total RNA levels and their confidence interval (levels plus and minus
one standard deviation), pre-RNA lelevs and their confidence intervals, synthsis rates and 
their confidence intervals, degradation rates and processing rates of the selected gene.
}
\description{
A method to see the shapes of the estimated synthesis, degradation and processing rates, pre-RNA and total RNA 
concentrations (solid thin lines) their variances (dashed lines) and the modeled rates and concentrations 
(ticker solid line) of a single gene.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
plotGene(nascentInspObj10, 1)
}
