% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/modelRatesNF-methods.R
\name{modelRatesNF}
\alias{modelRatesNF}
\alias{modelRatesNF,INSPEcT-method}
\title{Launch the modeling process without imposing sigmoid/impulse functional form}
\usage{
modelRatesNF(object, BPPARAM = SerialParam())

\S4method{modelRatesNF}{INSPEcT}(object, BPPARAM = SerialParam())
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{BPPARAM}{Parallelization parameters for bplapply. By default SerialParam()}
}
\value{
An object of class INSPEcT with modeled rates
}
\description{
This method compute confidence intervals for the rates of synthesis, degradation and processing estimated by 
\code{\link{newINSPEcT}} that will be used to estimate the variability of each rate in \code{\link{ratePvals}}
method.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
	nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
	## models removal
	nascentInspObjThreeGenes <- removeModel(nascentInspObj10[1:3])
	nascentInspObjThreeGenes <- modelRatesNF(nascentInspObjThreeGenes, 
	  BPPARAM=SerialParam())
	## view modeled synthesis rates
	viewModelRates(nascentInspObjThreeGenes, 'synthesis')
	## view gene classes
	geneClass(nascentInspObjThreeGenes)
}
}
