% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/steadyNoNascent-methods.R
\name{compareSteadyNoNascent}
\alias{compareSteadyNoNascent}
\alias{compareSteadyNoNascent,INSPEcT_steadyNoNascent-method}
\title{Identify post-transcriptionally regulated genes from an object of class INSPEcT_diffsteady}
\usage{
compareSteadyNoNascent(
  inspectIds,
  expressionThreshold = 0.25,
  log2FCThreshold = 2,
  trivialAngle = NaN,
  returnNormScores = FALSE,
  referenceCondition = "median"
)

\S4method{compareSteadyNoNascent}{INSPEcT_steadyNoNascent}(
  inspectIds,
  expressionThreshold = 0.25,
  log2FCThreshold = 2,
  trivialAngle = NaN,
  returnNormScores = FALSE,
  referenceCondition = "median"
)
}
\arguments{
\item{inspectIds}{An object of class INSPEcT_steadyNoNascent}

\item{expressionThreshold}{A parameter which sets how many log2 fold changes of distance from the median behaviour are imputable to noise.}

\item{log2FCThreshold}{A parameter which sets the log2 fold change distance from the median behaviour that is imputable to noise.}

\item{trivialAngle}{A numeric between 0 and 90 to define the standard behavior, if NaN (default) it is computed internally from the data.}

\item{returnNormScores}{A logical, if TRUE returned the deviations from the standard behavior normalized by the sd.}

\item{referenceCondition}{The label of the condition to use as reference, if NaN (default) the medians are used.}
}
\description{
This function compare exons and introns expression level matrices, from two up to an arbitrary number of samples, in order
to identify genes which are oddly regluated, compared to an expected standard behaviour, from the post transcriptional point of view.
}
\examples{
data('allcounts', package='INSPEcT')
data('featureWidths', package='INSPEcT')
data('libsizes', package='INSPEcT')

nascentCounts<-allcounts$nascent
matureCounts<-allcounts$mature
conditions<-letters[1:11]
expDes<-rep(conditions,3)

matExp_DESeq2<-quantifyExpressionsFromTrCounts(
      allcounts=matureCounts
      ,libsize=totalLS
      ,exonsWidths=exWdths
      ,intronsWidths=intWdths
      ,experimentalDesign=expDes)

matureInspObj <- newINSPEcT(tpts=conditions,matureExpressions=matExp_DESeq2)

matureInspObj<-compareSteadyNoNascent(inspectIds=matureInspObj
								 ,expressionThreshold=0.25
							 ,log2FCThreshold=.5)
regGenes <- PTreg(matureInspObj)
head(regGenes)
table(regGenes)
}
