% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_expression_partitioning.R
\name{expression_partitioning}
\alias{expression_partitioning}
\title{Partition genes in groups based on their expression patterns}
\usage{
expression_partitioning(deg_list)
}
\arguments{
\item{deg_list}{A list of data frames with gene-wise test statistics for
differentially expressed genes as returned by \code{get_deg_list()}.}
}
\value{
A data with the following variables:
\describe{
\item{Gene}{Character, gene ID.}
\item{Category}{Factor, expression group. Category names are numbers from
1 to 12.}
\item{Class}{Factor, expression group class. One of "UP" (transgressive
up-regulation), "DOWN" (transgressive down-regulation),
"ADD" (additivity), "ELD_P1" (expression-level dominance toward
the parent 1), or "ELD_P2" (expression-level dominance toward
the parent 2).}
}
}
\description{
Partition genes in groups based on their expression patterns
}
\examples{
data(deg_list)
exp_partitions <- expression_partitioning(deg_list)
}
