% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication_information.R
\name{publication_information}
\alias{publication_information}
\alias{print.publication_information}
\title{Publication Information Summaries from Publication UUID}
\usage{
publication_information(uuid)

\method{print}{publication_information}(x, ...)
}
\arguments{
\item{uuid}{character(1) corresponding to the HuBMAP Publication UUID
string. This is expected to be a 32-digit hex number.}

\item{x}{an object of class \code{publication_information}, the result of a
call to \code{publication_information()}.}

\item{...}{additional arguments, required to conform with the
\code{print} generic but not used.}
}
\value{
\code{publication_information()} returns a tibble,
and columns containing information about the publication. The
tibble is of class \code{publication_information} and is printed in character.

\code{print.publication_information()} is invoked automatically when
the result of \code{publication_information()} is displayed for it's
side effect of displaying the object.
}
\description{
\code{publication_information()} queries the HuBMAP publication for
title, abstract, manuscript,corresponding authors, dataset types, and organ.

\code{publication_information()} organizes the returned tibble
from \code{publication_information()} in a more legible format.
}
\examples{
uuid <- "e8338966c69e759157d6c6ad24847989"
publication_information(uuid)

}
