% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotting.R
\name{plotMatrix}
\alias{plotMatrix}
\alias{montage}
\alias{plotMatrix,HiCExperiment-method}
\alias{plotMatrix,GInteractions-method}
\alias{plotMatrix,matrix-method}
\alias{plotMatrix,AggrHiCExperiment-method}
\alias{montage,AggrHiCExperiment-method}
\title{Plotting a contact matrix}
\usage{
plotMatrix(x, ...)

montage(x, ...)

\S4method{plotMatrix}{HiCExperiment}(
  x,
  compare.to = NULL,
  use.scores = "balanced",
  scale = "log10",
  maxDistance = NULL,
  loops = NULL,
  borders = NULL,
  tracks = NULL,
  limits = NULL,
  dpi = 500,
  rasterize = TRUE,
  symmetrical = TRUE,
  chrom_lines = TRUE,
  show_grid = FALSE,
  cmap = NULL,
  caption = TRUE
)

\S4method{plotMatrix}{GInteractions}(
  x,
  use.scores = NULL,
  scale = "log10",
  maxDistance = NULL,
  loops = NULL,
  borders = NULL,
  tracks = NULL,
  limits = NULL,
  dpi = 500,
  rasterize = TRUE,
  symmetrical = TRUE,
  chrom_lines = TRUE,
  show_grid = FALSE,
  cmap = NULL
)

\S4method{plotMatrix}{matrix}(
  x,
  scale = "log10",
  limits = NULL,
  dpi = 500,
  rasterize = TRUE,
  cmap = NULL
)

\S4method{plotMatrix}{AggrHiCExperiment}(
  x,
  use.scores = "balanced",
  scale = "log10",
  maxDistance = NULL,
  loops = NULL,
  borders = NULL,
  limits = NULL,
  dpi = 500,
  rasterize = TRUE,
  chrom_lines = TRUE,
  show_grid = FALSE,
  cmap = NULL,
  caption = TRUE
)

\S4method{montage}{AggrHiCExperiment}(
  x,
  use.scores = "balanced",
  scale = "log10",
  limits = NULL,
  dpi = 500,
  rasterize = TRUE,
  cmap = NULL
)
}
\arguments{
\item{x}{A HiCExperiment object}

\item{...}{Extra arguments passed to the corresponding method.}

\item{compare.to}{Compare to a second HiC matrix in the lower left corner}

\item{use.scores}{Which scores to use in the heatmap}

\item{scale}{Any of 'log10', 'log2', 'linear', 'exp0.2' (Default: 'log10')}

\item{maxDistance}{maximum distance. If provided, the heatmap is plotted
horizontally}

\item{loops}{Loops to plot on top of the heatmap, provided as \code{GInteractions}}

\item{borders}{Borders to plot on top of the heatmap, provided as \code{GRanges}}

\item{tracks}{Named list of bigwig tracks imported as \code{Rle}}

\item{limits}{color map limits}

\item{dpi}{DPI to create the plot (Default: 500)}

\item{rasterize}{Whether the generated heatmap is rasterized or vectorized
(Default: TRUE)}

\item{symmetrical}{Whether to enforce a symetrical heatmap (Default: TRUE)}

\item{chrom_lines}{Whether to display separating lines between chromosomes,
should any be necessary (Default: TRUE)}

\item{show_grid}{Whether to display an underlying grid (Default: FALSE)}

\item{cmap}{Color scale to use. (Default: bgrColors() if limits are c(-1, 1)
and coolerColors() otherwise)}

\item{caption}{Whether to display a caption (Default: TRUE)}
}
\value{
ggplot object
}
\description{
Plotting a contact matrix
}
\examples{
contacts_yeast <- contacts_yeast()
plotMatrix(
    contacts_yeast, 
    use.scores = 'balanced', 
    scale = 'log10', 
    limits = c(-4, -1)
)
}
