% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compartments.R
\name{getCompartments}
\alias{getCompartments}
\title{Contact map compartments}
\usage{
getCompartments(
  x,
  resolution = NULL,
  genome = NULL,
  chromosomes = NULL,
  neigens = 3,
  sort_eigens = FALSE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{x}{A \code{HiCExperiment} object over a full genome}

\item{resolution}{Which resolution to use to compute eigen vectors}

\item{genome}{a BSgenome of DNAStringSet object associated with the Hi-C
contact matrix.}

\item{chromosomes}{character or integer vector indicating which}

\item{neigens}{Numver of eigen vectors to extract}

\item{sort_eigens}{Can be FALSE or one of c('Spearman', 'Pearson')}

\item{BPPARAM}{BiocParallel parallelization settings}
}
\value{
A \code{HiCExperiment} object with additional \code{eigens} metadata containing the
normalized eigenvectors and a new "compartments" topologicalFeatures
storing A and B compartments as a GRanges object.
}
\description{
Computes eigen vectors for each chromosome using cis contacts and extract
chromosome compartments.
}
\examples{
library(HiContacts)
full_contacts_yeast <- contacts_yeast(full = TRUE)
comps <- getCompartments(full_contacts_yeast)
metadata(comps)$eigens
}
