% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_sum.R
\name{total_sum}
\alias{total_sum}
\title{Total sum normalization for a list of hic.table objects}
\usage{
total_sum(hic.list)
}
\arguments{
\item{hic.list}{A list of hic.table objects created by the
create.hic.table function. When creating the hic.list
to be entered into this function you must set the
scale option to FALSE.}
}
\value{
A list of hic.table objects.
}
\description{
Total sum normalization for a list of hic.table objects
}
\details{
This function will scale the IFs based on the total sum
    of the counts for the genome instead of on a per
    chromosome basis as done in the create.hic.table function
    when the scale option is set to TRUE.
    The idea behind this function to
    preserve more local CNV differences while still accounting
    for technical biases which can cause the total read counts
    to differ between sequencing runs.
}
\examples{
data('HMEC.chr22')
data('NHEK.chr22')
data('HMEC.chr10')
data('NHEK.chr10')
hic.table1 <- create.hic.table(HMEC.chr22, NHEK.chr22,
    chr = 'chr22', scale = FALSE)
hic.table2 <- create.hic.table(HMEC.chr10, NHEK.chr10,
    chr = 'chr10', scale = FALSE)
hic.list <- list(hic.table1, hic.table2)
scaled_list <- total_sum(hic.list)
}
