% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionsByRegions.R
\name{interactionsByRegions}
\alias{interactionsByRegions}
\title{Filters HiCaptuRe object by overlaping regions}
\usage{
interactionsByRegions(
  interactions,
  regions,
  chr = NULL,
  start = NULL,
  end = NULL,
  invert = FALSE
)
}
\arguments{
\item{interactions}{HiCaptuRe object}

\item{regions}{full path to regions file (bed format) or a GRanges object}

\item{chr}{column name of chromosome values}

\item{start}{column name of start positions}

\item{end}{column name of end positions}

\item{invert}{TRUE/FALSE if need those interactions that do NOT overlaps with any regions}
}
\value{
HiCaptuRe object filtered by regions, by default with additional columns regarding overlap on each node. If invert=T no additional columns. And an additional slot ByRegions with region-centric statistics
}
\description{
This function filters a HiCaptuRe object from load_interactions by overlaping regions
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")
regions <- GenomicRanges::GRanges(seqnames = 19, ranges = IRanges::IRanges(start = c(500000, 1000000), end = c(510000, 1100000)))
interactions_regions <- interactionsByRegions(interactions = interactions, regions = regions)

}
