% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{HiCExperiment utils}
\alias{HiCExperiment utils}
\alias{splitCoords}
\alias{coords2char}
\alias{char2coords}
\alias{sortPairs}
\alias{asGInteractions}
\alias{sdiag}
\alias{.df2symmmat}
\alias{distanceDecay}
\alias{detrendingModel}
\alias{.fixRegions}
\title{Utils functions}
\usage{
splitCoords(coords)

coords2char(coords, big.mark = ",")

char2coords(char)

sortPairs(pairs)

asGInteractions(df)

sdiag(A, k = 0)

.df2symmmat(diag, score)

distanceDecay(dump, threshold = NULL)

detrendingModel(file, resolution)

.fixRegions(gis, bins, coords)
}
\arguments{
\item{coords}{A set of genomic coordinates (either as a GRanges
object or as a character string)}

\item{big.mark}{Separator for thousands when printing out genomic coordinates
as character}

\item{char}{char (e.g. "II:30001-50000" or "II:30001-50000|II:60001-80000")}

\item{pairs}{Pairs object}

\item{df}{a data.frame to turn into a GInteraction object.}

\item{A}{Numerical matrix}

\item{k}{secondary diagonal k}

\item{diag}{vector of distances to diagonal}

\item{score}{scores to parse into symmetrical matrix}

\item{dump}{dumped contacts as GInteractions, e.g. from .dumpCool}

\item{threshold}{maximum distance to compute distance decay for}

\item{file}{path to a HiC contact matrix file}

\item{resolution}{Resolution to use with the HiC contact matrix file}

\item{gis}{GInteractions object}

\item{bins}{Larger set of regions (usually bins from HiCExperiment)}
}
\value{
Reformatted coordinates or GInteractions.
}
\description{
Utilities to facilitate parsing/handling of coordinates, GInteractions,
Pairs, ...
These functions are not exported.
}
\keyword{internal}
