% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as}
\alias{as}
\alias{coerce,HiCExperiment,GInteractions-method}
\alias{coerce,HiCExperiment,InteractionSet-method}
\alias{coerce,HiCExperiment,ContactMatrix-method}
\alias{coerce,HiCExperiment,matrix-method}
\alias{coerce,HiCExperiment,data.frame-method}
\alias{as.matrix,HiCExperiment-method}
\alias{as.data.frame,HiCExperiment-method}
\alias{gi2cm}
\alias{cm2matrix}
\alias{df2gi}
\title{Coercing functions}
\usage{
\S4method{as.matrix}{HiCExperiment}(x, use.scores = "balanced", sparse = FALSE)

\S4method{as.data.frame}{HiCExperiment}(x)

gi2cm(gi, use.scores = "score")

cm2matrix(cm, replace_NA = NA, sparse = FALSE)

df2gi(
  df,
  seqnames1 = "seqnames1",
  start1 = "start1",
  end1 = "end1",
  seqnames2 = "seqnames2",
  start2 = "start2",
  end2 = "end2"
)
}
\arguments{
\item{x}{HiCExperiment object}

\item{use.scores}{Which scores to use to inflate GInteractions}

\item{sparse}{Whether to return the contact matrix as a sparse matrix}

\item{gi}{GInteractions object}

\item{cm}{A \code{ContactMatrix} object}

\item{replace_NA}{Replace NA values}

\item{df}{A \code{data.frame} object}

\item{seqnames1, start1, end1, seqnames2, start2, end2}{Names (as strings) of
columns containing corresponding information in a data.frame parsed into
GInteractions
(default: FALSE)}
}
\description{
Coercing functions available for HiCExperiment objects.
}
\examples{
mcoolPath <- HiContactsData::HiContactsData('yeast_wt', 'mcool')
contacts <- import(mcoolPath, focus = 'XVI', resolution = 16000, format = 'cool')
gis <- interactions(contacts)
cm <- gi2cm(gis, 'balanced')
cm
cm2matrix(cm)[1:10, 1:10]
df2gi(data.frame(
    chr1 = 'I', start1 = 10, end1 = 100, 
    chr2 = 'I', start2 = 40, end2 = 1000, 
    score = 12, 
    weight = 0.234, 
    filtered = TRUE
), seqnames1 = 'chr1', seqnames2 = 'chr2')
}
