% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoolFile-class.R, R/CoolFile-methods.R
\name{CoolFile-class}
\alias{CoolFile-class}
\alias{McoolFile-class}
\alias{CoolFile}
\alias{CoolFile-methods}
\alias{show,CoolFile-method}
\title{\code{CoolFile} S4 class}
\arguments{
\item{path}{String; path to a (m)cool file}

\item{resolution}{numeric; resolution to use with mcool file}

\item{pairsFile}{String; path to a pairs file}

\item{metadata}{list; if the CoolFile object was generated by HiCool::HiCool,
this list contains the path to log file, some statistics regarding
the number of pairs obtained by hicstuff as well as the arguments and
the hash ID used by HiCool.}

\item{object}{A \code{CoolFile} object.}
}
\description{
The \code{CoolFile} class describes a \code{BiocFile} object, pointing to the location
of an Hi-C matrix file (cool, mcool, hic, hicpro, ...) and containing additional slots:
\enumerate{
\item resolution: at which resolution the associated mcool file should be parsed
\item pairsFile: the path (in plain character) to an optional pairs file
(stored as a \code{PairsFile} object);
\item metadata: a list. If the CoolFile is created by \code{HiCool}, it will contain
two elements: \code{log} (path to \code{HiCool} processing log file) and \code{stats}
(aggregating some stats from \code{HiCool} mapping).
}

CoolFile methods.
}
\examples{
mcoolPath <- HiContactsData::HiContactsData('yeast_wt', 'mcool')
pairsPath <- HiContactsData::HiContactsData('yeast_wt', 'pairs.gz')
cf <- CoolFile(
  mcoolPath, 
  resolution = 2000, 
  pairsFile = pairsPath, 
  metadata = list(info = 'Yeast WT Hi-C exp.')
)
cf
resolution(cf)
pairsFile(cf)
metadata(cf)
}
\seealso{
\code{\link[=HicFile]{HicFile()}}, \code{\link[=HicproFile]{HicproFile()}}
}
