% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_1D_features.R
\name{expand_1D_features}
\alias{expand_1D_features}
\title{expand_1D_features}
\usage{
expand_1D_features(gi_list, chrs = NULL, features = NULL, agg = transform.vec)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects where each object
named with chromosomes contains intra-chromosomal interaction information
(see
\code{?gi_list_validate} for a detailed explanation of valid \code{gi_list}
 instances).}

\item{chrs}{a subset of chromosomes' e.g., c('chr21','chr22'). Defaults
to all chromosomes in the \code{gi_list} instance.}

\item{features}{features to be added. Defaults to all 1D features in
elements of \code{gi_list[[1]]@regions@elementMetadata}}

\item{agg}{any vector valued function with two data arguments:
defaults to \code{transform.vec} described in HiC-DC (Carty et al., 2017).}
}
\value{
a gi_list element with 2D features stored in metadata handle
(i.e., \code{mcols(gi)}).
}
\description{
Expands 1D features on the regions metadata handle
of each list element (e.g., \code{gi_list[[1]]@regions@elementMetadata})
to the to 2D metadata e.g., \code{mcols(gi_list[[1]])}). Two feature values
corresponding to each anchor is summarized as a score using a vector
valued function agg that takes two vector valued arguments of the same size
and outputs a vector of the same size as the input vectors. This defaults
to the \code{transform.vec} function outlined in (Carty et al., 2017). 
For efficient use of memory, using add/expand 1D features (see 
\code{?add_1D_features} and \code{expand_1D_features}) in sequence is
recommended instead of using \code{add_2D_features} directly
for each chromosome.
}
\examples{
df<-data.frame(chr='chr9',start=seq(1e6,10e6,1e6),end=seq(2e6,11e6,1e6))
gi_list<-generate_df_gi_list(df)
feats<-data.frame(chr='chr9',start=seq(1e6,10e6,1e6),gc=runif(10))
gi_list<-add_1D_features(gi_list,feats)
gi_list<-expand_1D_features(gi_list)
}
