% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_1D_features.R
\name{add_1D_features}
\alias{add_1D_features}
\title{add_1D_features}
\usage{
add_1D_features(gi_list, df, chrs = NULL, features = NULL, agg = mean)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects where each object
named with chromosomes contains intrachromosomal interaction information
(see
\code{?gi_list_validate} for a detailed explanation of valid \code{gi_list} instances).}

\item{df}{DataFrame with columns named 'chr', and'start' and features to
be added with their respective names.}

\item{chrs}{a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes
specified in the data frame \code{df}.}

\item{features}{features to be added. Needs to be a subset of 
\code{colnames(df)}. Defaults to all columns in \code{df} other than
'chr','start',and 'end'.}

\item{agg}{any vector valued function with one data argument:
defaults to \code{mean}.}
}
\value{
a gi_list instance with 1D features stored in regions metadata handle
of each list element (e.g., \code{gi_list[[1]]@regions@elementMetadata})
in the instance
}
\description{
Adds 1D features to the gi_list instance. If any bin on gi_list
overlaps with multiple feature records, feature values are aggregated
for the bin according to the
vector valued function agg (e.g., sum, mean)
}
\examples{
df<-data.frame(chr='chr9',start=seq(1e6,10e6,1e6),end=seq(2e6,11e6,1e6))
gi_list<-generate_df_gi_list(df)
feats<-data.frame(chr='chr9',start=seq(1e6,10e6,1e6),gc=runif(10))
gi_list<-add_1D_features(gi_list,feats)
}
