% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_vector_values}
\alias{Brick_get_vector_values}
\title{Return a N dimensional vector selection.}
\usage{
Brick_get_vector_values(
    Brick,
    chr1,
    chr2,
    resolution,
    xaxis,
    yaxis,
    FUN = NULL,
    force = FALSE
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr1}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the rows of the matrix}

\item{chr2}{\strong{Required}.
A character vector of length 1 specifying the chromosome corresponding to
the columns of the matrix}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{xaxis}{\strong{Required}.
A 1 dimensional vector containing the rows to retrieve. Gaps in this vector
may result in unexpected behaviour as the values which are considered are
min(xaxis) and max(xaxis) for retrieval.}

\item{yaxis}{\strong{Required}.
A 1 dimensional vector containing the columns to retrieve. Gaps in this
vector may result in unexpected behaviour as the values which are considered
are min(yaxis) and max(yaxis) for retrieval.}

\item{FUN}{\strong{Optional}. Default NULL
If provided a data transformation with FUN will be applied before the vector
is returned.}

\item{force}{\strong{Optional}. Default FALSE
If true, will force the retrieval operation when matrix contains loaded
data until a certain distance.}
}
\value{
Returns a vector of length yaxis if length of xaxis is 1. Else
returns a matrix of dimension xaxis length by yaxis length.
}
\description{
\code{Brick_get_vector_values} is the base function being used by all
other matrix retrieval functions.
}
\section{Note}{
 Whatever the length of xaxis or yaxis may be, the coordinates
under consideration will range from min(xaxis) to max(xaxis) on the rows or
min(yaxis) to max(yaxis) on the columns.
}

\examples{
Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "get_vector_val_test")

if(!file.exists(out_dir)){
    dir.create(out_dir)
}

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Brick_get_vector_values(Brick = My_BrickContainer, chr1 = "chr2L",
chr2 = "chr2L", resolution = 100000, xaxis = c(1:10), yaxis = c(1:10))

}
