% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one.R
\name{hpaXml}
\alias{hpaXml}
\title{Extract details about an individual protein from XML file in one function}
\usage{
hpaXml(
  inputXml,
  extractType = c("ProtClass", "TissueExprSum", "Antibody", "TissueExpr"),
  ...
)
}
\arguments{
\item{inputXml}{Input can be either one Ensembl gene id (start with ENSG) or
a imported XML object resulting from a \code{hpaXmlGet()} function call.
You can also use HGNC gene symbol and it will be converted to ensembl id.}

\item{extractType}{A vector of strings indicate which information is desired
for extraction. By default this function will call all \code{hpaXml}
functions available. Other options are \code{'ProtClass'},
\code{'TissueExprSum'}, \code{'Antibody'}, \code{'TissueExpr'}.}

\item{...}{Additional arguments to be passed downstream to other hpaXml
functions being called behind the scene. See help files of other hpaXml
functions for more information.}
}
\value{
This function returns a list. Each element of the list is information
  extracted from the XML file specified using other hpaXml functions. See
  help file for each XML function for more information.
}
\description{
This function is the umbrella function for the hpaXml function family. It
take the input of either one Ensembl gene id or a imported XML object
resulting from a \code{hpaXmlGet()} function call. By default, it will
extract all information available for HPAanalyze user from the XML file by
calling every hpaXml function and put all results into a list.
}
\examples{
 
  hpaXml(inputXml='ENSG00000131979', extractType=c('ProtClass', 'TissueExprSum', 'Antibody'))

}
\seealso{
Other xml functions: 
\code{\link{hpaXmlAntibody}()},
\code{\link{hpaXmlGet}()},
\code{\link{hpaXmlProtClass}()},
\code{\link{hpaXmlTissueExpr}()},
\code{\link{hpaXmlTissueExprSum}()}
}
\concept{xml functions}
