% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{hippo}
\alias{hippo}
\title{HIPPO's hierarchical clustering}
\usage{
hippo(sce, K = 20, z_threshold = 2, outlier_proportion = 0.001, verbose = TRUE)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{K}{number of clusters to ultimately get}

\item{z_threshold}{numeric > 0 as a z-value threshold
for selecting the features}

\item{outlier_proportion}{numeric between 0 and 1, a cut-off
so that when the proportion of important features reach this
number, the clustering terminates}

\item{verbose}{if set to TRUE, it shows progress of the algorithm}
}
\value{
a list of clustering result for each level of k=1, 2, ... K.
}
\description{
HIPPO's hierarchical clustering
}
\examples{
data(toydata)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
}
