% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloscope.R
\name{gloscope}
\alias{gloscope}
\title{Calculate statistical divergence between all sample pairs}
\usage{
gloscope(
  embedding_matrix,
  cell_sample_ids,
  dens = c("GMM", "KNN"),
  dist_metric = c("KL", "JS"),
  r = 10000,
  num_components = c(5, 10, 15, 20),
  k = 50,
  GMM_params = list(modelNames = c("VVE"), verbose = FALSE, plot = FALSE),
  KNN_params = NULL,
  BPPARAM = BiocParallel::SerialParam(),
  prefit_density = NULL,
  return_density = FALSE
)
}
\arguments{
\item{embedding_matrix}{a matrix or data.frame of latent embeddings with rows
corresponding to cells and columns to dimensions}

\item{cell_sample_ids}{a vector of the samples IDs each cell comes from. Length
must match the number of rows in `embedding_matrix`}

\item{dens}{the density estimation. One of c("GMM","KNN")}

\item{dist_metric}{distance metric to calculate the distance. One of
c("KL","JS")}

\item{r}{number of Monte Carlo simulations to generate}

\item{num_components}{a vector of integers for the number of components to
fit GMMs to, default is c(5,10,15,20)}

\item{k}{number of nearest neighbours for KNN density estimation, default k =
50.}

\item{GMM_params}{optional mclust parameters, default is to restrict the fit
model to only VVE}

\item{KNN_params}{optional arguments for either `FNN:KL.dist` (KL) or
`RANN::nn2` (JS), default is NULL}

\item{BPPARAM}{BiocParallel parameters, default is running in serial. Set
random seed with `RNGseed` argument}

\item{prefit_density}{a named list of pre-fit `densityMclust` objects for
each sample, default is NULL}

\item{return_density}{return the GMM parameter list or not (if applicable),
default is FALSE}
}
\value{
A matrix containing the pairwise divergence or distance between all
  pairs of samples
}
\description{
This function calculates a matrix of pairwise divergences
  between input samples of single cell data.
}
\examples{
# Bring in small example data of single cell embeddings
data(example_SCE_small)
sample_ids <- SingleCellExperiment::colData(example_SCE_small)$sample_id 
pca_embeddings <- SingleCellExperiment::reducedDim(example_SCE_small,"PCA")
# Run gloscope on first 10 PCA embeddings
# We use 'KNN' option for speed ('GMM' is slightly slower)
pca_embeddings_subset <- pca_embeddings[,seq_len(10)] # select the first 10 PCs
dist_result <- gloscope(pca_embeddings_subset, sample_ids,
         dens="KNN", BPPARAM = BiocParallel::SerialParam(RNGseed=2))
dist_result

}
