% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1-glMDPlot.R
\name{glMDPlot.DESeqDataSet}
\alias{glMDPlot.DESeqDataSet}
\title{Glimma MD Plot}
\usage{
\method{glMDPlot}{DESeqDataSet}(
  x,
  counts = NULL,
  anno,
  groups,
  samples = NULL,
  status = rep(0, nrow(x)),
  transform = FALSE,
  main = "",
  xlab = "Mean Expression",
  ylab = "log-fold-change",
  side.xlab = "Group",
  side.ylab = "logMean",
  side.log = FALSE,
  side.gridstep = ifelse(!transform || side.log, FALSE, 0.5),
  jitter = 30,
  side.main = "GeneID",
  display.columns = NULL,
  cols = c("#00bfff", "#858585", "#ff3030"),
  sample.cols = rep("#1f77b4", ncol(x)),
  path = getwd(),
  folder = "glimma-plots",
  html = "MD-Plot",
  launch = TRUE,
  ...
)
}
\arguments{
\item{x}{the DESeqDataSet object.}

\item{counts}{the matrix of expression values, with samples in columns.}

\item{anno}{the data.frame containing gene annotations.}

\item{groups}{the factor containing experimental groups of the samples.}

\item{samples}{the names of the samples.}

\item{status}{vector giving the control status of data point, of same length
as the number of rows of object. If NULL, then all points are plotted in
the default colour.}

\item{transform}{TRUE if counts should be log-cpm transformed.}

\item{main}{the title for the left plot.}

\item{xlab}{label for x axis on left plot.}

\item{ylab}{label for y axis on left plot.}

\item{side.xlab}{label for x axis on right plot.}

\item{side.ylab}{label for y axis on right plot.}

\item{side.log}{TRUE to plot expression on the right plot on log scale.}

\item{side.gridstep}{intervals along which to place grid lines on y axis.
Currently only available for linear scale.}

\item{jitter}{the amount of jitter to apply to the samples in the expressions
plot.}

\item{side.main}{the column containing mains for right plot.}

\item{display.columns}{character vector containing names of columns to
display in mouseover tooltips and table.}

\item{cols}{vector of strings denoting colours corresponding to control
status -1, 0 and 1. (may be R named colours or Hex values)}

\item{sample.cols}{vector of strings denoting colours for each sample point
on the expression plot.}

\item{path}{the path in which the folder will be created.}

\item{folder}{the name of the fold to save html file to.}

\item{html}{the name of the html file to save plots to.}

\item{launch}{TRUE to launch plot after call.}

\item{...}{additional arguments to be passed onto the MD plot. (main, xlab,
ylab can be set for the left plot)}
}
\value{
Draws a two-panel interactive MD plot in an html page. The left plot
  shows the log-fold-change vs average expression. The right plot shows the
  expression levels of a particular gene of each sample. Hovering over points
  on left plot will plot expression level for corresponding gene, clicking on
  points will fix the expression plot to gene. Clicking on rows on the table
  has the same effect as clicking on the corresponding gene in the plot.
}
\description{
Draw an interactive MD plot from a DESeqDataSet object
}
\author{
Shian Su
}
