% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-autoplot.R
\name{plotConcordance}
\alias{plotConcordance}
\title{Generate concordance figure of targets based on user provided factors}
\usage{
plotConcordance(targetList, object, plotFactor)
}
\arguments{
\item{targetList}{names of targets to plot concordance, normally IgGs.}

\item{object}{name of the object class to subset
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{plotFactor}{segment factor to color the plot by}
}
\description{
Upper panels are the concordance plot.
Lower panels are the standard deviation of the log2-ratios between the targets
}
\examples{
proteinData <- readRDS(file= system.file("extdata","DSP_Proteogenomics_Example_Data", 
"proteinData.rds", package = "GeomxTools"))

igg.names <- iggNames(proteinData)

protSegTypeFig <- plotConcordance(targetList = igg.names, object = proteinData, 
                                  plotFactor = "Segment_Type")
protSegTypeFig

}
