% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-aggregate.R
\name{aggregateCounts}
\alias{aggregateCounts}
\title{Aggregate probe counts to target level for feature data}
\usage{
aggregateCounts(object, FUN = ngeoMean)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to aggregate}

\item{FUN}{function to use for count aggregation}
}
\value{
a NanoStringGeoMxSet object with targets as features
}
\description{
Aggregate probe counts to target level for feature data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
targetGeoMxSet <- aggregateCounts(demoData[,1:10])

}
