% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merge_methylation.R
\name{differential_methy}
\alias{differential_methy}
\title{differential_methy}
\usage{
differential_methy(
  cpgData,
  sampleGroup,
  groupCol,
  combineMethod = "stouffer",
  missing_value = "knn",
  cpg2gene = NULL,
  normMethod = "PBC",
  region = "TSS1500",
  model = "gene",
  adjust.method = "BH",
  adjPvalCutoff = 0.05,
  ucscData = FALSE
)
}
\arguments{
\item{cpgData}{data.frame of cpg beta value, , or SummarizedExperiment object}

\item{sampleGroup}{vector of sample group}

\item{groupCol}{group column}

\item{combineMethod}{method to combine the cpg pvalues, 
a function or one of "stouffer", "fisher" and "rhoScores".}

\item{missing_value}{Method to impute missing expression data,
one of "zero" and "knn".}

\item{cpg2gene}{data.frame to annotate cpg locus to gene}

\item{normMethod}{Method to do normalization: "PBC" or "BMIQ".}

\item{region}{region of genes, one of "Body", "TSS1500", "TSS200",
"3'UTR", "1stExon", "5'UTR", and "IGR". Only used when cpg2gene is NULL.}

\item{model}{if "cpg", step1: calculate difference cpgs;
step2: calculate difference genes.
if "gene", step1: calculate the methylation level of genes;
step2: calculate difference genes.}

\item{adjust.method}{character string specifying the method
used to adjust p-values for multiple testing.
See \link{p.adjust} for possible values.}

\item{adjPvalCutoff}{adjusted pvalue cutoff}

\item{ucscData}{Logical, whether the data comes from UCSC Xena.}
}
\value{
data.frame
}
\description{
Get methylation difference gene
}
\examples{
\donttest{
# use TCGAbiolinks data
library(TCGAbiolinks)
query <- GDCquery(project = "TCGA-ACC",
    data.category = "DNA Methylation",
    data.type = "Methylation Beta Value",
    platform = "Illumina Human Methylation 450")
GDCdownload(query, method = "api", files.per.chunk = 5,
    directory = Your_Path)
merge_result <- Merge_methy_tcga(Your_Path_to_DNA_Methylation_data)
library(ChAMP) # To avoid reporting errors
differential_gene <- differential_methy(cpgData = merge_result,
    sampleGroup = sample(c("C","T"),
    ncol(merge_result[[1]]), replace = TRUE))
}
# use user defined data
library(ChAMP)
cpgData <- matrix(runif(2000), nrow = 200, ncol = 10)
rownames(cpgData) <- paste0("cpg", seq_len(200))
colnames(cpgData) <- paste0("sample", seq_len(10))
sampleGroup <- c(rep("group1", 5), rep("group2", 5))
names(sampleGroup) <- colnames(cpgData)
cpg2gene <- data.frame(cpg = rownames(cpgData), 
    gene = rep(paste0("gene", seq_len(20)), 10))
result <- differential_methy(cpgData, sampleGroup, 
    cpg2gene = cpg2gene, normMethod = NULL)
# use SummarizedExperiment object input
library(ChAMP)
cpgData <- matrix(runif(2000), nrow = 200, ncol = 10)
rownames(cpgData) <- paste0("cpg", seq_len(200))
colnames(cpgData) <- paste0("sample", seq_len(10))
sampleGroup <- c(rep("group1", 5), rep("group2", 5))
names(sampleGroup) <- colnames(cpgData)
cpg2gene <- data.frame(cpg = rownames(cpgData), 
    gene = rep(paste0("gene", seq_len(20)), 10))
colData <- S4Vectors::DataFrame(
    row.names = colnames(cpgData),
    group = sampleGroup
)
data <- SummarizedExperiment::SummarizedExperiment(
         assays=S4Vectors::SimpleList(counts=cpgData),
         colData = colData)
result <- differential_methy(cpgData = data, 
    groupCol = "group", normMethod = NULL, 
    cpg2gene = cpg2gene)  
}
