% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{combine_pvalue}
\alias{combine_pvalue}
\title{combine pvalues of SNP difference analysis result}
\usage{
combine_pvalue(snpResult, snp2gene, combineMethod = min)
}
\arguments{
\item{snpResult}{data.frame of SNP difference analysis result.}

\item{snp2gene}{data frame of two column: snp and gene.}

\item{combineMethod}{Method of combining the
pvalue of multiple snp in a gene.}
}
\value{
data.frame
}
\description{
combine pvalues of SNP difference analysis result
}
\examples{
snpResult <- data.frame(pvalue = runif(100), estimate = runif(100))
rownames(snpResult) <- paste0("snp", seq_len(100))
snp2gene <- data.frame(snp = rownames(snpResult), 
    gene = rep(paste0("gene", seq_len(20)), 5))
result <- combine_pvalue(snpResult, snp2gene)
}
