% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetadata.R
\name{getStudyInfo}
\alias{getStudyInfo}
\title{Extract information on a specific training dataset}
\usage{
getStudyInfo(RAVmodel, study)
}
\arguments{
\item{RAVmodel}{A PCAGenomicSignatures object}

\item{study}{A character for SRA study accession.}
}
\value{
A list with three elements: studyTitle, studySize (the number of
samples from this study used in the RAVmodel building), and RAVs. 'RAVs' is
a data frame with three columns - PC (1 to 20), RAV (RAV that the given PC
belongs to), and Variance explained (%). In the example, we used
miniRAVmodel, which doesn't have all the PCA summary information, so the
example will return only the two PCs of the study instead of all twenty.
}
\description{
Extract information on a specific training dataset
}
\examples{
data(miniRAVmodel)
getStudyInfo(miniRAVmodel, "SRP028155")

}
