% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrom-plots.R
\name{plotChromBins}
\alias{plotChromBins}
\title{Plot distribution over chromosomes}
\usage{
plotChromBins(
  genomeAggregate,
  plotTitle = "Distribution over chromosomes",
  ylim = "max"
)
}
\arguments{
\item{genomeAggregate}{The output from the genomicDistribution function}

\item{plotTitle}{Title for plot.}

\item{ylim}{Limit of y-axes. Default "max" sets limit to N of biggest bin.}
}
\value{
A ggplot object showing the distribution of the query 
    regions over bins of
the reference genome.
}
\description{
Plots result from \code{genomicDistribution} calculation
}
\examples{
agg = data.frame("regionID"=1:5, "chr"=rep(c("chr1"), 5), 
                "withinGroupID"=1:5, "N"=c(1,3,5,7,9))  
ChromBins = plotChromBins(agg)

}
