% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-plots.R
\name{calcGCContentRef}
\alias{calcGCContentRef}
\title{Calculate GC content over genomic ranges}
\usage{
calcGCContentRef(query, refAssembly)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{refAssembly}{A character vector specifying the reference genome
assembly (*e.g.* 'hg19'). This will be used to grab chromosome sizes with
\code{getTSSs}.}
}
\value{
A numeric vector or list of vectors with the GC percentage of 
    the query regions.
}
\description{
Given a reference genome as a BSgenome object and some ranges on that
reference, this function will return a vector of the same length as the
granges object, with percent of Cs and Gs.
}
\examples{
\dontrun{
refAssembly = 'hg19'
GCcontent = calcGCContentRef(vistaEnhancers, refAssembly)
} 
}
