% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coord.R
\name{get_coord}
\alias{get_coord}
\alias{get_coord,BaseGroup_OR_CodonGroup-method}
\alias{get_coord,DNAStringSet_OR_NULL-method}
\title{DNA base/codon sequence and coordinates represented on a given
Abelian group.}
\usage{
get_coord(x, ...)

\S4method{get_coord}{BaseGroup_OR_CodonGroup}(x, output = c("all", "matrix.list"))

\S4method{get_coord}{DNAStringSet_OR_NULL}(
  x,
  output = c("all", "matrix.list"),
  base_seq = TRUE,
  filepath = NULL,
  cube = "ACGT",
  group = "Z4",
  start = NA,
  end = NA,
  chr = 1L,
  strand = "+"
)
}
\arguments{
\item{x}{An object from a \code{\link{BaseGroup-class}},
\code{\link{CodonGroup-class}},
\code{\link[Biostrings]{DNAStringSet}} or
\code{\link[Biostrings]{DNAMultipleAlignment}} class carrying the DNA
pairwise alignment of two sequences. Objects from
\code{\link{BaseGroup-class}} and \code{\link{CodonGroup-class}} are
generated with functions: \code{\link{base_coord}} and
\code{\link{codon_coord}}, respectively.}

\item{...}{Not in use.}

\item{output}{See 'Value' section.}

\item{base_seq}{Logical. Whether to return the base or codon coordinates on
the selected Abelian group. If codon coordinates are requested, then the
number of the DNA bases in the given sequences must be multiple of 3.}

\item{filepath}{A character vector containing the path to a file in
\emph{\strong{fasta}} format to be read. This argument must be given if
\emph{codon & base} arguments are not provided.}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2 2 3).}

\item{group}{A character string denoting the group representation for the
given base or codon as shown in reference (1).}

\item{start, end, chr, strand}{Optional parameters required to build a
\code{\link[GenomicRanges]{GRanges-class}}. If not provided the default
values given for the function definition will be used.}
}
\value{
An object from \code{\link{CodonGroup-class}} class is returned
when \emph{output = 'all'}. This has two slots, the first one carrying a
list of matrices and the second one carrying the codon/base sequence
information. That is, if \emph{x} is an object from
\code{\link{CodonGroup-class}} class, then a list of matrices of codon
coordinate can be retrieved as x@CoordList and the information on the
codon sequence as x@SeqRanges.

if \emph{output = 'matrix.list'}, then an object from
\code{\link{MatrixList}} class is returned.
}
\description{
Given a string denoting a codon or base from the DNA (or RNA)
alphabet and a genetic-code Abelian group as given in reference (1), this
function returns an object from \code{\link{CodonGroup-class}} carrying the
DNA base/codon sequence and coordinates represented on the given Abelian
group.
}
\details{
Symbols '-' and 'N' usually found in DNA sequence alignments to
denote gaps and missing/unknown bases are represented by the number: '-1'
on Z4 and '0' in Z5. In Z64 the symbol 'NA' will be returned for codons
including symbols '-' and 'N'.

Although the \code{\link{CodonGroup-class}} object returned by
functions \code{\link{codon_coord}} and \code{\link{base_coord}} are useful
to store genomic information, the base and codon coordinates are not given
on them as numeric magnitudes. Function \code{\link{get_coord}} provides
the way to get the coordinates in a numeric object in object from and still
to preserve the base/codon sequence information.
}
\examples{
## Load a pairwise alignment
data("aln", package = "GenomAutomorphism")
aln

## DNA base representation in the Abelian group Z5
coord <- get_coord(
    x = aln,
    cube = "ACGT",
    group = "Z5"
)
coord ## A list of vectors

## Extract the coordinate list
coordList(coord)

## Extract the sequence list
seqRanges(coord)

## DNA codon representation in the Abelian group Z64
coord <- get_coord(
    x = aln,
    base_seq = FALSE,
    cube = "ACGT",
    group = "Z64"
)
coord

## Extract the coordinate list
coordList(coord)

## Extract the sequence list
seqRanges(coord)

}
