% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automorphismByRanges.R
\name{automorphismByRanges}
\alias{automorphismByRanges}
\alias{automorphismByRanges,Automorphism-method}
\alias{automorphismByRanges,AutomorphismList-method}
\title{Get the automorphisms by ranges.}
\usage{
automorphismByRanges(x, ...)

\S4method{automorphismByRanges}{Automorphism}(x)

\S4method{automorphismByRanges}{AutomorphismList}(
  x,
  min.len = 0L,
  num.cores = multicoreWorkers(),
  tasks = 0L,
  verbose = TRUE
)
}
\arguments{
\item{x}{An AutomorphismList-class object returned by function
\code{\link{automorphisms}}.}

\item{...}{Not in use.}

\item{min.len}{Minimum length of a range to be reported.}

\item{num.cores, tasks}{Integers. Argument \emph{num.cores} denotes the
number of cores to use, i.e. at most how many child processes will be run
simultaneously (see \code{\link[BiocParallel]{bplapply}} function from
BiocParallel package). Argument \emph{tasks} denotes the number of tasks per
job. value must be a scalar integer >= 0L. In this documentation a job is
defined as a single call to a function, such as
\code{\link[BiocParallel]{bplapply}}. A task is the division of the \eqn{X}
argument into chunks. When tasks == 0 (default), \eqn{X} is divided as
evenly as possible over the number of workers (see
\code{\link[BiocParallel]{MulticoreParam}} from BiocParallel package).}

\item{verbose}{logic(1). If TRUE, enable progress bar.}
}
\value{
A  \code{\link[GenomicRanges]{GRanges-class}} or a
\code{\link[GenomicRanges]{GRangesList-class}}. Each
\code{\link[GenomicRanges]{GRanges-class}} object with a column
named \emph{cube}, which carries the type of \emph{cube} automorphims.
}
\description{
Automorphisms estimated on a pairwise or a MSA alignment
can be grouped by ranges which inherits from
\code{\link[GenomicRanges]{GRanges-class}} or a
\code{\link[GenomicRanges]{GRanges-class}}.
}
\examples{
## Load dataset
data("autm", package = "GenomAutomorphism")

automorphismByRanges(x = autm[c(1, 4)])

}
