% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickAnalysis.R
\name{whippetTranscriptChangeSummary}
\alias{whippetTranscriptChangeSummary}
\title{Compare open reading frames for whippet differentially spliced events}
\usage{
whippetTranscriptChangeSummary(whippetDataSet, gtf.all = NULL, BSgenome,
  eventTypes = "all", exons = NULL, transcripts = NULL, NMD = FALSE,
  exportGTF = NULL)
}
\arguments{
\item{whippetDataSet}{whippetDataSet generated from \code{readWhippetDataSet()}}

\item{gtf.all}{GRanges gtf annotation (can be used instead of specifying exons and transcripts)}

\item{BSgenome}{BSGenome object containing the genome for the species analysed}

\item{eventTypes}{which event type to filter for? default = "all"}

\item{exons}{GRanges gtf annotation of exons}

\item{transcripts}{GRanges gtf annotation of transcripts}

\item{NMD}{Use NMD predictions? (Note: notNMD must be installed to use this feature)}

\item{exportGTF}{file name to export alternative isoform GTFs (default=NULL)}
}
\value{
data.frame containing signficant whippet diff data and ORF change summaries
}
\description{
Compare open reading frames for whippet differentially spliced events
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10
whippetTranscriptChangeSummary(wds, gtf.all=gtf,BSgenome = g)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{filterWhippetEvents}},
  \code{\link{formatWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDIFFfiles}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetJNCfiles}},
  \code{\link{readWhippetPSIfiles}}
}
\author{
Beth Signal
}
