% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SignatureDistance.R
\name{SignatureDistance}
\alias{SignatureDistance}
\title{Compute pairwise distances comprehensively}
\usage{
SignatureDistance(
  exprSet,
  SignatureLength,
  MergingDistance = c("Spearman", "Kendall"),
  ScoringMethod = c("GSEA", "PGSEA"),
  ScoringDistance = c("avg", "max"),
  weighted = TRUE,
  ...
)
}
\arguments{
\item{exprSet}{an \code{ExpressionSet} object, each column of assay data represents
a ranked list obtained by preprocessing the corresponding gene expression
profile, and phenotypic data represents the short description
(characteristics of gene expression profile, such as the drug type, the
disease state) about the assay data.}

\item{SignatureLength}{the length of "gene signature". In order to compute
pairwise distances among samples, genes lists are ranked according to the
gene expression ratio (fold change). And the "gene signature" includes the
most up-regulated genes (near the top of the list) and the most
down-regulated genes (near the bottom of the list).}

\item{MergingDistance}{distance to be used which "measures" the similarity
of ordered lists, "Spearman" or "Kendall".}

\item{ScoringMethod}{method to be used to perform distance scoring, "GSEA"
or "PGSEA".}

\item{ScoringDistance}{the distance measurements between PRLs: the Average
Enrichment Score Distance ("avg"), or the Maximum Enrichment Score Distance
("max").}

\item{weighted}{there are tow rank merging approaches for two cases: if
\code{weighted = FALSE}, all ranked list with the same biological state are
treated equally important, a simple but useful method average ranking
technique is selected; otherwise, \code{weighted = TRUE}, each individual
ranked lists has its own ranked weights, this takes the iterative
rank-aggregating algorithm, default is \code{TRUE}.}

\item{...}{additional arguments can be passed to \code{\link[=ScoreGSEA]{ScoreGSEA()}}(while
\code{ScoringMethod = "GSEA"}) or to \code{\link[=ScorePGSEA]{ScorePGSEA()}}(while
\code{ScoringMethod = "PGSEA"}.}
}
\value{
the result from \code{\link[=ScoreGSEA]{ScoreGSEA()}} or \code{\link[=ScorePGSEA]{ScorePGSEA()}}.
}
\description{
This function integrated the function for rank merging and distance scoring,
we can do the rank merging and distance scoring simply with it.
}
\examples{
#load the sample expressionSet
data(exampleSet)

# distance scoring
SignatureDistance(
  exampleSet,
  SignatureLength = 250,
  MergingDistance = "Spearman", 
  ScoringMethod = "GSEA",
  ScoringDistance = "avg",
  weighted = TRUE
)
}
\seealso{
\code{\link[=RankMerging]{RankMerging()}},\code{\link[=ScoreGSEA]{ScoreGSEA()}},\code{\link[=ScorePGSEA]{ScorePGSEA()}}
}
