% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rainfall-class.R
\name{Rainfall-class}
\alias{Rainfall-class}
\alias{Rainfall}
\title{Class Rainfall}
\usage{
Rainfall(
  object,
  BSgenome = NULL,
  palette = NULL,
  sectionHeights = NULL,
  chromosomes = NULL,
  sample = NULL,
  pointSize = NULL,
  verbose = FALSE,
  plotALayers = NULL,
  plotBLayers = NULL
)
}
\arguments{
\item{object}{Object of class MutationAnnotationFormat, GMS, VEP.}

\item{BSgenome}{Object of class BSgenome to extract genome wide chromosome coordinates}

\item{palette}{Character vector specifying colors used for encoding transitions and transversions
, should be of length 7. If NULL a default palette will be used.}

\item{sectionHeights}{Numeric vector specifying relative heights of each plot section,
should sum to one. Expects a value for each section.}

\item{chromosomes}{Character vector specifying chromosomes for which to plot}

\item{sample}{Character vector specifying the samples for which to plot.}

\item{pointSize}{numeric value giving the size of points to plot (defaults to 2)}

\item{verbose}{Boolean specifying if status messages should be reported.}

\item{plotALayers}{list of ggplot2 layers to be passed to the rainfall plot.}

\item{plotBLayers}{list of ggplot2 layers to be passed to the density plot.}
}
\description{
An S4 class for the Rainfall plot object, under development!!!
}
\section{Slots}{

\describe{
\item{\code{PlotA}}{gtable object for the rainfall plot}

\item{\code{PlotB}}{gtable object for density plots based on the rainfall plot}

\item{\code{Grob}}{gtable object for the arranged plot}

\item{\code{primaryData}}{data.table object storing the primary data used for plotting.}
}}

