% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_histogram.R
\name{gsHistogram}
\alias{gsHistogram}
\title{Create a histogram plot for gene set sizes}
\usage{
gsHistogram(
  genesets,
  gs_names,
  gs_description = NULL,
  start = 0,
  end = 0,
  binwidth = 5,
  color = "#0092AC"
)
}
\arguments{
\item{genesets}{a \code{list}, A \code{list} of genesets where each genesets is
represented by \code{list} of genes.}

\item{gs_names}{character vector, Name / identifier of the genesets in
\code{genesets}}

\item{gs_description}{Optional, a character vector containing a short
description for each geneset}

\item{start}{numeric, Optional, describes the minimum gene set size to
include. Defaults to 0.}

\item{end}{numeric, Optional, describes the maximum gene set size to include.
Defaults to 0.}

\item{binwidth}{numeric, Width of histogram bins. Defaults to 5.}

\item{color}{character, Fill color for histogram bars. Defaults to #0092AC.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot object.
}
\description{
Create a histogram plot to plot geneset names / identifiers against their
size.
}
\examples{
## Mock example showing how the data should look like
gs_names <- c("a", "b", "c", "d", "e", "f", "g", "h")
genesets <- list(
  c("PDHB", "VARS2", "IARS2", "PDHA1"),
  c("AAAS", "ABCE1"), c("ABI1", "AAR2", "AATF"), c("AMFR"),
  c("BMS1", "DAP3"), c("AURKAIP1", "CHCHD1"), c("IARS2"),
  c("AHI1", "ALMS1")
)

p <- gsHistogram(genesets, gs_names, binwidth = 1)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
p <- gsHistogram(genes, macrophage_topGO_example_small$Genesets)
}
