% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{z_summary}
\alias{z_summary}
\title{Calculating Z summary}
\usage{
z_summary(observed_stat, permutations_array)
}
\arguments{
\item{observed_stat}{matrix, bidimensional matrix containing the topological
matrix computed for each module by \code{\link[NetRep]{modulePreservation}}
(the element \code{observed}). Modules are in row, metrics are in column.}

\item{permutations_array}{matrix, tridimensional matrix containing the
topological matrix computed for each module by
\code{\link[NetRep]{modulePreservation}} (the element \code{observed}).
Modules are in dim 1, metrics are in dim 2, permutations are in dim 3.}
}
\value{
A named vector of the z summary statistic with the module id as name.
}
\description{
Use the topological metrics and permutations from output of
\code{\link[NetRep]{modulePreservation}} to compute a Z summary (a composite
preservation statistic) as defined by
\href{Langfelder et al. (2011)}{https://doi.org/10.1371/journal.pcbi.1001057}
}
\details{
The original Zsummary composite preservation statistic was defined
by Langfelder et al. (2011). However this method use the metric from
\code{\link[NetRep]{modulePreservation}} since they it handle better large
and multiple testing correction.
}
\examples{
expr_by_cond <- list(cond1 = kuehne_expr[1:24, 1:350],
                     cond2 = kuehne_expr[25:48, 1:350])
net_by_cond <- lapply(expr_by_cond, build_net, cor_func = "spearman",
                      n_threads = 1, keep_matrices = "both")

mods_labels <- setNames(
  sample(1:6, 350, replace = TRUE,
         prob = c(0.05, 0.4, 0.25, 0.15, 0.1, 0.05)),
  colnames(expr_by_cond$cond1))

netrep_res <- NetRep::modulePreservation(
  network = lapply(net_by_cond, `[[`, "adja_mat"),
  data = lapply(expr_by_cond, as.matrix),
  correlation = lapply(net_by_cond, `[[`, "cor_mat"),
  moduleAssignments = mods_labels,  nPerm = 100)

z_summary(netrep_res$observed, netrep_res$nulls)

mod_by_cond <- mapply(detect_modules, expr_by_cond,
                      lapply(net_by_cond, `[[`, "network"),
                      MoreArgs = list(detailled_result = TRUE),
                      SIMPLIFY = FALSE)

comparison <- compare_conditions(expr_by_cond,
                                 lapply(net_by_cond, `[[`, "adja_mat"),
                                 lapply(net_by_cond, `[[`, "cor_mat"),
                                 lapply(mod_by_cond, `[[`, "modules"),
                                 n_perm = 100)

z_summary(comparison$result$cond1$cond2$observed,
          comparison$result$cond1$cond2$nulls)

}
