% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBestAlnInfo.R
\name{getBestAlnInfo}
\alias{getBestAlnInfo}
\title{Parse pairwise alignment}
\usage{
getBestAlnInfo(
  offtargetSeq,
  pa.f,
  pa.r,
  gRNA.size = 20,
  PAM = "NGG",
  PAM.size = 3,
  insertion.symbol = "^"
)
}
\arguments{
\item{offtargetSeq}{DNAStringSet object of length 1}

\item{pa.f}{Global-Local PairwiseAlignmentsSingleSubject, results of
pairwiseAlignment, alignment of pattern to subject}

\item{pa.r}{Global-Local PairwiseAlignmentsSingleSubject, results of
pairwiseAlignment, alignment of pattern to reverse subject}

\item{gRNA.size}{size of gRNA, default to 20}

\item{PAM}{PAM sequence, default to NGG}

\item{PAM.size}{PAM size, default to 3}

\item{insertion.symbol}{symbol for representing bulge in offtarget,
default to ^. It can also be set to lowerCase to use lower case letter
to represent insertion}
}
\value{
a dataframe with the following columns.
offTarget: name of the offtarget
peak_score: place holder for storing peak score
gRNA.name: place holder for storing gRNA name
gRNAPlusPAM: place holder for storing gRNAPlusPAM sequence
offTarget_sequence: offTarget sequence with PAM in the right orientation.
For PAM in the 3' prime location, offTarget is the sequence on the plus strand
otherwise, is the sequence on the reverse strand
seq.aligned: the aligned sequence without PAM
guideAlignment2OffTarget: string representation of the alignment
offTargetStrand: the strand of the offtarget
mismatch.distance2PAM: mismatch distance to PAM start
n.PAM.mismatch: number of mismatches in PAM
n.guide.mismatch: number of mismatches in the gRNA not including PAM
PAM.sequence: PAM in the offtarget
offTarget_Start: offtarget start
offTarget_End: offTarget end
chromosome: place holder for storing offtarget chromosome
pos.mismatch: mismatch positions with the correct PAM orientation, i.e.,
indexed form distal to proximal of PAM
pos.indel: indel positions starting with deletions in the gRNA followed
by those in the offtarget
pos.insertion: Insertion positions in the gRNA
Insertion positions are counted from distal to proximal of PAM
For example, 5 means the 5th position is an insertion in
gRNA
pos.deletion: Deletion in the gRNA
Deletion positions are counted from distal to proximal of PAM
For example, 5 means the 5th position is a deletion in
gRNA
n.insertion: Number of insertions in the RNA. Insertions in gRNA creates
bulged DNA base
n.deletion: Number of deletions in the RNA. Deletions in gRNA creates
bulged DNA base
}
\description{
Parse pairwise alignment
}
\author{
Lihua Julie Zhu
}
