% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{plot_gene_group}
\alias{plot_gene_group}
\title{Plot a module}
\usage{
plot_gene_group(
  gnet_result,
  group_idx,
  tree_layout = 1,
  max_gene_num = 100,
  plot_leaf_labels = TRUE,
  group_labels = NULL
)
}
\arguments{
\item{gnet_result}{Results returned by gnet().}

\item{group_idx}{Index of the module.}

\item{tree_layout}{zoom ratio for the regulatory tree. Default is 1. Need to be increased for trees with >5 regulators.}

\item{max_gene_num}{Max size of gene to plot in the heatmap. Only genes with highest n variances will be kept.}

\item{plot_leaf_labels}{If the plot includes a color bar of leaf labels at the bottom.}

\item{group_labels}{Labels of experiment conditions,Used for the color bar of experiment conditions. Default is NULL}
}
\value{
None
}
\description{
Plot the regulators module and heatmap of the expression inferred downstream genes for each sample. 
It can be interpreted as two parts: the bars at the top shows how samples are splited by the 
regression tree and the heatmap at the bottom shows how downstream genes are regulated by each 
subgroup determined by the regulators.
}
\examples{
set.seed(1)
init_group_num = 5
init_method = 'boosting'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
plot_gene_group(gnet_result,group_idx=1)
}
