% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_module.R
\name{extract_edges}
\alias{extract_edges}
\title{Extract the network from the gnet result}
\usage{
extract_edges(gnet_result)
}
\arguments{
\item{gnet_result}{Returned results from gnet().}
}
\value{
A matrix of scores of for the regulator-target interaction.
}
\description{
Extract the network as edge list from the gnet result. For a module, each regulator and downstream gene will form a directed edge.
}
\examples{
set.seed(1)
init_group_num = 8
init_method = 'kmeans'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
edge_list <- extract_edges(gnet_result)
}
