% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud.R
\name{gcloud_access_token}
\alias{gcloud_access_token}
\title{Obtain an access token for a service account}
\usage{
gcloud_access_token(service)
}
\arguments{
\item{service}{\code{character(1)} The name of the service, e.g. "terra" for which
to obtain an access token for.}
}
\value{
\code{gcloud_access_token()} returns a simple token string to be used with
the given service.
}
\description{
\code{gcloud_access_token()} generates a token for the given service
account. The token is cached for the duration of its validity. The token is
refreshed when it expires. The token is obtained using the \code{gcloud} command
line utility for the given \code{gcloud_account()}. The function is mainly used
internally by API service functions, e.g., \code{AnVIL::Terra()}
}
\examples{
\dontshow{if (gcloud_exists()) withAutoprint(\{ # examplesIf}
gcloud_access_token("rawls") |> invisible()
\dontshow{\}) # examplesIf}
}
