% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getCountGenoMissing}
\alias{getCountGenoMissing}
\alias{getCountGenoMissing,GbsrGenotypeData-method}
\title{Obtain total missing genotype counts per SNP or per sample}
\usage{
getCountGenoMissing(object, target = "marker", valid = TRUE, prop = FALSE, ...)

\S4method{getCountGenoMissing}{GbsrGenotypeData}(object, target, valid, prop)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{prop}{A logical value whether to return values as proportions
of total missing genotype counts to the total genotype calls or not.}

\item{...}{Unused.}
}
\value{
A numeric vector of (proportion of)
missing genotype calls per marker.
}
\description{
Obtain total missing genotype counts per SNP or per sample
}
\details{
You need to execute \code{\link[=countGenotype]{countGenotype()}} to calculate sumaary statisticsto be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)
gds <- countGenotype(gds)
getCountGenoMissing(gds)
closeGDS(gds) # Close the connection to the GDS file

}
