% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R,
%   R/Methods-GbsrScheme.R
\name{addScheme}
\alias{addScheme}
\alias{addScheme,GbsrGenotypeData-method}
\alias{addScheme,GbsrScheme-method}
\title{#' Build a \link{GbsrScheme} object}
\usage{
addScheme(object, crosstype, mating, ...)

\S4method{addScheme}{GbsrGenotypeData}(object, crosstype, mating)

\S4method{addScheme}{GbsrScheme}(object, crosstype, mating)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{crosstype}{A string to indicate the type of
cross conducted with a given generation.}

\item{mating}{An integer matrix to indicate mating combinations.
The each element should match with member IDs of the last generation.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object storing
a \link{GbsrScheme} object in the "scheme" slot.
}
\description{
\link{GBScleanR} uses breeding scheme information to set the expected
number of cross overs in a chromosome which is a required parameter
for the genotype error correction with the Hidden Markov model
implemented in the \code{estGeno()} function.
This function build the object storing
type crosses performed at each generation of breeding and population sizes.
}
\details{
A scheme object is just a data.frame indicating a population size and
a type of cross applied to each generation of the breeding process
to generate the population which you are going to subject
to the \code{\link[=estGeno]{estGeno()}} function.
The \code{crosstype} can take either of "selfing", "sibling",
"pairing", and "random".
When you set \code{crosstype = "random"}, you need to
specify \code{pop_size} to indicate how many
individuals were crossed in the random mating.
You also need to specify a matrix indicating
combinations of \code{mating}, in which
each column shows a pair of member IDs indicating
parental samples of the cross.
Member IDs are serial numbers starts from 1 and
automatically assigned by
\code{\link[=initScheme]{initScheme()}} and \code{\link[=addScheme]{addScheme()}}. To check the member IDs,
run \code{\link[=showScheme]{showScheme()}}.
Please see the examples section for more details of
specifying a \code{mating} matrix.
The created \link{GbsrScheme} object is set in the \code{scheme}
slot of the \link{GbsrGenotypeData} object.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Biparental F2 population.
gds <- setParents(gds, parents = c("Founder1", "Founder2"))

# setParents gave member ID 1 and 2 to Founder1 and Founder2, respectively.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Now the progenies of the cross above have member ID 3.
# If `crosstype = "selfing"` or `"sibling"`, you can omit a `mating` matrix.
gds <- addScheme(gds, crosstype = "self")

############################################################################
# Now you can execute `estGeno()` which requires a [GbsrScheme] object.

# Close the connection to the GDS file
closeGDS(gds)
}
\seealso{
\code{\link[=addScheme]{addScheme()}} and \code{\link[=showScheme]{showScheme()}}
}
