% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_plotFeatCov.R
\name{GARS_PlotFeaturesUsage}
\alias{GARS_PlotFeaturesUsage}
\title{A bubble chart to assess the usage of each features}
\usage{
GARS_PlotFeaturesUsage(popul.list, allFeat, nFeat = length(allFeat))
}
\arguments{
\item{popul.list}{A SummarizedExpression object}

\item{allFeat}{A character vector containing the list of the all
features name. Often, it corresponds to the columns name of the data
matrix.}

\item{nFeat}{The number of features which have to be plotted.
Default is '\code{length(allFeat)}'}
}
\value{
A bubble chart where each plotted feature is represented by a
colored circle. A feature is important (i.e. conserved) if the size is
wide and the color tends to red; the smaller the size, the lighter
the color and less informative the feature.
}
\description{
This function allows assessing visually how many times
 a feature is selected across the generations. In principle, a
 highly recurring feature is more likely to be important.
}
\examples{
# use example data:
data(GARS_data_norm)
data(GARS_pop_list)
allfeat_names <- colnames(GARS_data_norm)
GARS_PlotFeaturesUsage(GARS_pop_list, allfeat_names, nFeat = 10)
}
\seealso{
\code{\link{GARS_PlotFitnessEvolution}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
