% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariant.R
\name{getVariant}
\alias{getVariant}
\title{getVariant function}
\usage{
getVariant(host, variantId, asVCF = TRUE)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{variantId}{The ID of the Variant to be retrieved.}

\item{asVCF}{If \code{TRUE} the function will return an \code{\link{VCF}}
with header (default), otherwise it will return an
\code{DataFrame}.}
}
\value{
\code{\link{VCF}} object (when \code{asVCF = TRUE}) or
\code{\link{DataFrame}} object (otherwise).
}
\description{
Get a variant by its ID with all call sets for this variant.
}
\details{
This function requests \code{GET host/variants/variantId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
variantId <- searchVariants(host, variantSetId, "1", 15031, 15031)$id
getVariant(host, variantId)

getVariant(host, variantId, asVCF = FALSE)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/variant_service.proto.html#GetVariant}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchVariants}},
\code{\link{searchVariantsByGRanges}}, \code{\link{VCF}},
\code{\link{makeVCFFromGA4GHResponse}}
}
