% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmds.R
\name{mdsObj}
\alias{mdsObj}
\title{Objective term of MDS}
\usage{
mdsObj(D, z, N)
}
\arguments{
\item{D}{Original distance matrix}

\item{z}{Lower dimension representation}

\item{N}{Number of observations--scaling factors}
}
\value{
Scalar of objective function value of MDS
}
\description{
Objective term of MDS
}
\examples{
require(phyloseq)
data(microbiome)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
z0 <- cmdscale(d = D)
N <- dim(z0)[1]
mdsObj(D = D, z = z0, N = N)
}
