% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permanova.R
\name{getP}
\alias{getP}
\title{Compute p-value from PERMANOVA test}
\usage{
getP(z = NULL, D = NULL, y, n_iter = 999)
}
\arguments{
\item{z}{Object matrix; used to build distance matrix d; d is prioritized}

\item{D}{Distance matrix; if NULL, obtain from mat using Euclidean distance}

\item{y}{Vector of treatments}

\item{n_iter}{Number of iterations; defaults to 999}
}
\value{
list of ratio_all: vector of obtained pseudo-F values from permutations,
ratio: pseudo-F value, p: p-value from PERMANOVA
}
\description{
Compute p-value from PERMANOVA test
}
\examples{
require(phyloseq)
data(microbiome)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
y <- sample_data(microbiome)$Treatment
getP(D = D, y = y)
}
