% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmds.R
\name{fmds}
\alias{fmds}
\title{FMDS calculation using MM algorithm}
\usage{
fmds(D = NULL, y, X, nit = 100, lambda = 0.5, threshold_p = 0.05, z0 = NULL)
}
\arguments{
\item{D}{Square matrix of pairwise distance, size of N by N}

\item{y}{Vector of label or group set, size of N}

\item{X}{Object matrix; used to build distance matrix D; D is prioritized}

\item{nit}{Number of iterations; 100 by default}

\item{lambda}{Hyperparameter; 0.5 by default}

\item{threshold_p}{Lower limit of p-value difference that allows iteration}

\item{z0}{Initialization of configuration; NULL by default}
}
\value{
2D representation vector, size of N by 2
}
\description{
FMDS calculation using MM algorithm
}
\examples{
set.seed(100)
require(phyloseq)
data(microbiome)
D <- distance(microbiome, method = 'wunifrac') # requires phyloseq package
y <- sample_data(microbiome)$Treatment
z0 <- cmdscale(d = D)
fmds(z0 = z0, D = D, y = y)
}
