% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatSeekR.R
\name{FeatSeek}
\alias{FeatSeek}
\title{FeatSeek}
\usage{
FeatSeek(
  data,
  conditions = NULL,
  max_features = NULL,
  init = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{\code{SummarizedExperiment} with assay named \code{data}, 
where samples
belongs to different conditions. Which sample belongs to which condition
should be indicated in \code{colData} slot conditions. 
Or \code{matrix} with features x samples.
Each conditions have multiple samples from replicated measurements.}

\item{conditions}{factor of length samples,
indicating which sample belongs to which condition. Only required if 
\code{data} is provided as \code{matrix}.}

\item{max_features}{\code{integer} number of features to rank}

\item{init}{\code{character vector} with names of initial features.
If \code{NULL} the feature with highest F-statistic will be used}

\item{verbose}{\code{logical} indicating whether messages should be printed}
}
\value{
\code{SummarizedExperiment} containing one assay with the 
selected features. \code{rowData} stores for each selected feature the 
F-statistic under \code{metric},
the cumulative explained variance under \code{explained_variance} and
the feature names under \code{selected}
}
\description{
This function ranks features of a 2
dimensional array according to their reproducibility between conditions.
}
\examples{
# run FeatSeek to select the top 20 features
data <-  array(rnorm(100*30), dim=c(30, 100),
dimnames <- list(paste("feature", seq_len(30)), NULL))
conds <- rep(seq_len(50), 2)
res <- FeatSeek(data, conds, max_features=20)

# res stores the 20 selected features ranked by their replicate 
# reproducibility

}
