% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEAST.R
\name{FEAST}
\alias{FEAST}
\title{FEAST main function}
\usage{
FEAST(
  Y,
  k = 2,
  num_pcs = 10,
  dim_reduce = c("irlba", "svd", "pca"),
  split = FALSE,
  batch_size = 1000,
  nProc = 1
)
}
\arguments{
\item{Y}{A expression matrix. Raw count matrix or normalized matrix.}

\item{k}{The number of input clusters (best guess).}

\item{num_pcs}{The number of top pcs that will be investigated through the consensus clustering.}

\item{dim_reduce}{dimension reduction methods chosen from pca, svd, or irlba.}

\item{split}{boolean. If T, using subsampling to calculate the gene-level significance.}

\item{batch_size}{when split is true, need to claim the batch size for spliting the cells.}

\item{nProc}{number of cores for BiocParallel enviroment.}
}
\value{
the rankings of the gene-significance.
}
\description{
FEAST main function
}
\examples{
data(Yan)
k = length(unique(trueclass))
set.seed(123)
rixs = sample(nrow(Y), 500)
cixs = sample(ncol(Y), 40)
Y = Y[rixs, cixs]
ixs = FEAST(Y, k=k)
}
