% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Consensus_Clustering_Mclust.R
\name{Consensus}
\alias{Consensus}
\title{Consensus Clustering}
\usage{
Consensus(Y, num_pcs = 10, top_pctg = 0.33, k = 2, thred = 0.9, nProc = 1)
}
\arguments{
\item{Y}{A expression matrix. It is recommended to use the raw count matrix. Users can input normalized matrix directly.}

\item{num_pcs}{The number of top pcs that will be investigated on through consensus clustering.}

\item{top_pctg}{Top percentage of features for dimension reduction}

\item{k}{The number of input clusters (best guess).}

\item{thred}{For the final GMM clustering, the probability of a cell belonging to a certain cluster.}

\item{nProc}{number of cores for BiocParallel enviroment.}
}
\value{
the clustering labels and the featured genes.
}
\description{
Consensus Clustering
}
\examples{
data(Yan)
set.seed(123)
rixs = sample(nrow(Y), 500)
cixs = sample(ncol(Y), 40)
Y = Y[rixs, cixs]
con = Consensus(Y, k=5)
}
