% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetColData}
\alias{subsetColData}
\alias{subsetColData<-}
\alias{subsetColData,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetColData<-,SubsetRangedSummarizedExperiment,character,DataFrame-method}
\alias{subsetColData,SubsetSingleCellExperiment,character-method}
\alias{subsetColData<-,SubsetSingleCellExperiment,character,DataFrame-method}
\alias{subsetColData<-,SubsetSummarizedExperiment,character,DataFrame-method}
\alias{subsetColData,SubsetSummarizedExperiment,character-method}
\alias{subsetColData,SubsetSpatialExperiment,character-method}
\alias{subsetColData<-,SubsetSpatialExperiment,character,DataFrame-method}
\alias{subsetColData,SubsetTreeSummarizedExperiment,character-method}
\alias{subsetColData<-,SubsetTreeSummarizedExperiment,character,DataFrame-method}
\title{Accessor method for colData from subsets in ExperimentSubset objects}
\usage{
subsetColData(x, subsetName, parentColData)

subsetColData(x, subsetName) <- value

\S4method{subsetColData}{SubsetRangedSummarizedExperiment,character}(x, subsetName, parentColData)

\S4method{subsetColData}{SubsetRangedSummarizedExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetColData}{SubsetSingleCellExperiment,character}(x, subsetName, parentColData)

\S4method{subsetColData}{SubsetSingleCellExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetColData}{SubsetSummarizedExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetColData}{SubsetSummarizedExperiment,character}(x, subsetName, parentColData)

\S4method{subsetColData}{SubsetSpatialExperiment,character}(x, subsetName, parentColData)

\S4method{subsetColData}{SubsetSpatialExperiment,character,DataFrame}(x, subsetName) <- value

\S4method{subsetColData}{SubsetTreeSummarizedExperiment,character}(x, subsetName, parentColData)

\S4method{subsetColData}{SubsetTreeSummarizedExperiment,character,DataFrame}(x, subsetName) <- value
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}

\item{subsetName}{\code{character(1)} Name of the subset to set
\code{colData} to.}

\item{parentColData}{\code{logical(1)} Logical value indicating if parent
colData should be combined or not. Default \code{FALSE}.}

\item{value}{Input \code{DataFrame} to store.}
}
\value{
The \code{colData} from input object.

Input object with \code{colData} stored.
}
\description{
Get \code{colData} from a subset.

Set \code{colData} to a subset.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetColData(es, "subset1")
}
