% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_single_command.R
\name{TCGA_GetData}
\alias{TCGA_GetData}
\title{The TCGA_GetData function}
\usage{
TCGA_GetData(
  CancerSite,
  mode = "Regular",
  outputDirectory = ".",
  doBatchCorrection = FALSE,
  batch.correction.method = "Seurat",
  roadmap.epigenome.ids = NULL,
  roadmap.epigenome.groups = NULL,
  forceUse450K = FALSE,
  cores = 1
)
}
\arguments{
\item{CancerSite}{character string indicating the TCGA cancer code. The information can be found at: https://gdc.cancer.gov/resources-tcga-users/tcga-code-tables/tcga-study-abbreviations}

\item{mode}{character string indicating the analytic mode to model DNA methylation. Should be one of the followings: 'Regular', 'Enhancer', 'miRNA' or 'lncRNA'. Default: 'Regular'. See details for more information.}

\item{outputDirectory}{character string indicating the file path to save the output.}

\item{doBatchCorrection}{logical indicating whether to do batch effect correction during preprocessing. Default: False.}

\item{batch.correction.method}{character string indicating the method to perform batch effect correction. The value should be either 'Seurat' or 'Combat'. Seurat is much fatster than the Combat. Default: 'Seurat'.}

\item{roadmap.epigenome.ids}{character vector indicating the epigenome ID(s) to be used for selecting enhancers. See details for more information. Default: NULL.}

\item{roadmap.epigenome.groups}{character vector indicating the tissue group(s) to be used for selecting enhancers. See details for more information. Default: NULL.}

\item{forceUse450K}{logic indicating whether force to use only 450K methylation data. Default: FALSE}

\item{cores}{Number of CPU cores to be used for computation.}
}
\value{
The results from EpiMix is a list with the following components:
\item{MethylationDrivers}{CpG probes identified as differentially methylated by EpiMix.}
\item{NrComponents}{The number of methylation states found for each driver probe.}
\item{MixtureStates}{A list with the DM-values for each driver probe.
Differential Methylation values (DM-values) are defined as the difference between
the methylation mean of samples in one mixture component from the experiment group and the methylation mean
in samples from the control group, for a given probe.}
\item{MethylationStates}{Matrix with DM-values for all driver probes (rows) and all samples (columns).}
\item{Classifications}{Matrix with integers indicating to which mixture component each sample in the experiment group was assigned to, for each probe.}
\item{Models}{Beta mixture model parameters for each driver probe.}
\item{group.1}{sample names in group.1 (experimental group).}
\item{group.2}{sample names in group.2 (control group).}
\item{FunctionalPairs}{Dataframe with the prevalence of differential methyaltion for each CpG probe in the sample population, and fold change of mRNA expression and P values for each signifcant probe-gene pair.}
}
\description{
This function wraps the functions for downloading, pre-processing and analysis of the DNA methylation and gene expression data from the TCGA project.
}
\details{
mode:
EpiMix incorporates four alternative analytic modes for modeling DNA methylation: “Regular,” “Enhancer”, “miRNA” and “lncRNA”.
The four analytic modes target DNA methylation analysis on different genetic elements.
The Regular mode aims to model DNA methylation at proximal cis-regulatory elements of protein-coding genes.
The Enhancer mode targets DNA methylation analysis on distal enhancers.
The miRNA or lncRNA mode focuses on methylation analysis of miRNA- or lncRNA-coding genes.

roadmap.epigenome.groups & roadmap.epigenome.ids:

Since enhancers are cell-type or tissue-type specific, EpiMix needs to know the reference tissues or cell types in order to select proper enhancers.
EpiMix identifies enhancers from the RoadmapEpigenomic project (Nature, PMID: 25693563), in which enhancers were identified by ChromHMM in over 100 tissue and cell types.
Available epigenome groups (a group of relevant cell types) or epigenome ids (individual cell types) can be obtained from the original publication (Nature, PMID: 25693563, figure 2).
They can also be retrieved from the list.epigenomes() function. If both roadmap.epigenome.groups and roadmap.epigenome.ids are specified, EpiMix will select all the epigenomes from the combination of the inputs.
}
\examples{
\donttest{
# Example #1 - Regular mode
EpiMixResults <- TCGA_GetData(CancerSite = 'LUAD',
                              outputDirectory = tempdir(),
                              cores = 8)

# Example #2 - Enhancer mode
EpiMixResults <- TCGA_GetData(CancerSite = 'LUAD',
                              mode =  'Enhancer',
                              roadmap.epigenome.ids = 'E097',
                              outputDirectory = tempdir(),
                              cores = 8)

Example #3 - miRNA mode
EpiMixResults <- TCGA_GetData(CancerSite = 'LUAD',
                              mode = 'miRNA',
                              outputDirectory = tempdir(),
                              cores = 8)

#' Example #4 - lncRNA mode
EpiMixResults <- TCGA_GetData(CancerSite = 'LUAD',
                              mode = 'lncRNA',
                              outputDirectory = tempdir(),
                              cores = 8)

}

}
