% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{EpiMix_PlotModel}
\alias{EpiMix_PlotModel}
\title{The EpiMix_PlotModel function.}
\usage{
EpiMix_PlotModel(
  EpiMixResults,
  Probe,
  methylation.data,
  gene.expression.data = NULL,
  GeneName = NULL,
  axis.title.font = 20,
  axis.text.font = 16,
  legend.title.font = 18,
  legend.text.font = 18,
  plot.title.font = 20
)
}
\arguments{
\item{EpiMixResults}{resulting list object from the EpiMix function.}

\item{Probe}{character string indicating the name of the CpG probe for which to create a mixture model plot.}

\item{methylation.data}{Matrix with the methylation data with genes in rows and samples in columns.}

\item{gene.expression.data}{Gene expression data with genes in rows and samples in columns (optional). Default: NULL.}

\item{GeneName}{character string indicating the name of the gene whose expression will be ploted with the EpiMix plot (optional). Default: NULL.}

\item{axis.title.font}{font size for the axis legend.}

\item{axis.text.font}{font size for the axis label.}

\item{legend.title.font}{font size for the legend title.}

\item{legend.text.font}{font size for the legend label.}

\item{plot.title.font}{font size for the plot title.}
}
\value{
A list of EpiMix plots:
\item{MixtureModelPlot}{a histogram of the distribution of DNA methylation data}
\item{ViolinPlot}{a violin plot of gene expression levels in different mixutures in the MixtureModelPlot}
\item{CorrelationPlot}{a scatter plot between DNA methylation and gene expression}
}
\description{
Produce the mixture model and the gene expression plots representing the EpiMix results.
}
\details{
The violin plot and the scatter plot will be NULL if the gene expression data or the GeneName is not provided
}
\examples{
{
data(MET.data)
data(mRNA.data)
data(Sample_EpiMixResults_Regular)

probe = "cg14029001"
gene.name = "CCND3"
plots <- EpiMix_PlotModel(
                          EpiMixResults = Sample_EpiMixResults_Regular,
                          Probe = probe,
                          methylation.data = MET.data,
                          gene.expression.data = mRNA.data,
                          GeneName = gene.name
                           )
plots$MixtureModelPlot
plots$ViolinPlot
plots$CorreilationPlot
}

}
